/********************************************************************
 * File:		serial.c
 * Purpose:		Board specific routines for the Mpc5500
 ********************************************************************/

#include "serial.h"
#include "ESCI_Esys.h"
#include "mpc5561.h"


//*********************************************************
//	Initialise serial port for printf
//	Use Baud 57600kbps / No par / 8 data bits / 1 stop bit
//*********************************************************

void setup_eSCI(void)
{
  register uint16_t ubgs;

  /* Enable SCI Module */
  ESCI0_SCICR3 = (0 
	    | ESCI_BSTP);
		
  /* Set the baud rate to 115,200 */
  ubgs = (uint16_t)((SYS_CLK)/(115200 * 16));
  ESCI0_SCIBD = ubgs;
    
  /* Even parity, 1 stop bit, 1 start bit, No loopback */
  /* 8-bits per character, idle bit count after stop bit */
  ESCI0_SCICR1 = (0 
	    | ESCI_ILT);
                 
  /* Enable receiver and transmitter */
  ESCI0_SCICR2 = (0
	    | ESCI_TE
	    | ESCI_RE);
      
	SIU.PCR[89].R = 0x0713;		 							//Set the SCIA_TX pad for primary operation       
}


/********************************************************************
 *	SCI_A
 ********************************************************************/
char
sci_a_getchar (void)
{
    /* Wait until character has been received */
    while (!(ESCI0_SCISR1 & ESCI_RDRF));
    
    /* Needed only for Windsor2 */	
    ESCI0_SCISR1 = ESCI_RDRF;
		
    return ESCI0_SCIDRL;
}
/********************************************************************/
void
sci_a_putchar (char ch)
{
// 	int delay_t = 0;
    /* Wait until space is available in the FIFO */
//     while (!(ESCI0_SCISR1 & ESCI_TDRE));
    while (ESCI_A.SR.B.TDRE != 1);
    ESCI0_SCISR1_full = 0x80000000;              /* Clear TDRE flag */
    /* Needed only for Windsor2 */	
//     ESCI0_SCISR1 = ESCI_TDRE;

    /* Send the character */
    ESCI0_SCIDRH = 0x0;
    ESCI0_SCIDRL = (uint8_t)ch;
    
    /* Use delay to stop innacurate results */
//     for (delay_t = 0; delay_t <0x10000; delay_t ++)
//     {delay_t = delay_t;}
    
//     while(ESCI_A.SR.B.TDRE == 0) {}       /* Wait for transmit data reg empty = 1 */
}
/********************************************************************/
int
sci_a_getchar_present (void)
{
    return (ESCI0_SCISR1 & ESCI_RDRF);
}
/********************************************************************
 *	SCI_B
 ********************************************************************/
char
sci_b_getchar (void)
{
    /* Wait until character has been received */
    while (!(ESCI1_SCISR1 & ESCI_RDRF));
    
    /* Needed only for Windsor2 */	
    ESCI1_SCISR1 = ESCI_RDRF;
		
    return ESCI1_SCIDRL;
}
/********************************************************************/
void
sci_b_putchar (char ch)
{
    /* Wait until space is available in the FIFO */
    while (!(ESCI1_SCISR1 & ESCI_TDRE));
    
    /* Needed only for Windsor2 */	
    ESCI1_SCISR1 = ESCI_TDRE;
		
    /* Send the character */
    ESCI1_SCIDRH = 0x0;
    ESCI1_SCIDRL = (uint8_t)ch;
}
/********************************************************************/
int
sci_b_getchar_present (void)
{
    return (ESCI1_SCISR1 & ESCI_RDRF);
}


